import type { CallToolRequest, ListResourcesRequest } from '@modelcontextprotocol/sdk/types.js';
import { type ServerDefinition } from './config.js';
import { type Logger } from './logging.js';
import './sdk-patches.js';
import { type ClientContext } from './runtime/transport.js';
export declare const MCPORTER_VERSION: string;
export interface RuntimeOptions {
    readonly configPath?: string;
    readonly servers?: ServerDefinition[];
    readonly rootDir?: string;
    readonly clientInfo?: {
        name: string;
        version: string;
    };
    readonly logger?: RuntimeLogger;
    readonly oauthTimeoutMs?: number;
}
export type RuntimeLogger = Logger;
export interface CallOptions {
    readonly args?: CallToolRequest['params']['arguments'];
    readonly timeoutMs?: number;
}
export interface ListToolsOptions {
    readonly includeSchema?: boolean;
    readonly autoAuthorize?: boolean;
    readonly allowCachedAuth?: boolean;
}
export interface Runtime {
    listServers(): string[];
    getDefinitions(): ServerDefinition[];
    getDefinition(server: string): ServerDefinition;
    registerDefinition(definition: ServerDefinition, options?: {
        overwrite?: boolean;
    }): void;
    listTools(server: string, options?: ListToolsOptions): Promise<ServerToolInfo[]>;
    callTool(server: string, toolName: string, options?: CallOptions): Promise<unknown>;
    listResources(server: string, options?: Partial<ListResourcesRequest['params']>): Promise<unknown>;
    connect(server: string): Promise<ClientContext>;
    close(server?: string): Promise<void>;
}
export interface ServerToolInfo {
    readonly name: string;
    readonly description?: string;
    readonly inputSchema?: unknown;
    readonly outputSchema?: unknown;
}
export declare function createRuntime(options?: RuntimeOptions): Promise<Runtime>;
export declare function callOnce(params: {
    server: string;
    toolName: string;
    args?: Record<string, unknown>;
    configPath?: string;
}): Promise<unknown>;
export { readJsonFile, writeJsonFile } from './fs-json.js';
//# sourceMappingURL=runtime.d.ts.map