import { analyzeConnectionError } from './error-classifier.js';
export function maybeEnableOAuth(definition, logger) {
    if (definition.auth === 'oauth') {
        return undefined;
    }
    if (definition.command.kind !== 'http') {
        return undefined;
    }
    const isAdHocSource = definition.source && definition.source.kind === 'local' && definition.source.path === '<adhoc>';
    if (!isAdHocSource) {
        return undefined;
    }
    logger.info(`Detected OAuth requirement for '${definition.name}'. Launching browser flow...`);
    return {
        ...definition,
        auth: 'oauth',
    };
}
export function isUnauthorizedError(error) {
    const issue = analyzeConnectionError(error);
    return issue.kind === 'auth';
}
//# sourceMappingURL=runtime-oauth-support.js.map