import { normalizeHttpUrl } from './http-utils.js';
export function findServerByHttpUrl(definitions, urlString) {
    const normalizedTarget = normalizeHttpUrl(urlString);
    if (!normalizedTarget) {
        return undefined;
    }
    for (const definition of definitions) {
        if (definition.command.kind !== 'http') {
            continue;
        }
        const normalizedDefinitionUrl = normalizeHttpUrl(definition.command.url);
        if (!normalizedDefinitionUrl) {
            continue;
        }
        if (normalizedDefinitionUrl === normalizedTarget) {
            return definition.name;
        }
    }
    return undefined;
}
//# sourceMappingURL=server-lookup.js.map