import { execFile } from 'node:child_process';
export async function resolveRuntimeKind(runtimeOption, compileOption) {
    if (runtimeOption) {
        return runtimeOption;
    }
    const bunAvailable = await isBunAvailable();
    if (compileOption && !bunAvailable) {
        throw new Error('--compile requires Bun. Install Bun or set BUN_BIN to the bun executable.');
    }
    return bunAvailable ? 'bun' : 'node';
}
export async function verifyBunAvailable() {
    const bunBin = process.env.BUN_BIN ?? 'bun';
    await new Promise((resolve, reject) => {
        execFile(bunBin, ['--version'], { cwd: process.cwd(), env: process.env }, (error) => {
            if (error) {
                reject(new Error('Unable to locate Bun runtime. Install Bun or set BUN_BIN to the bun executable.'));
                return;
            }
            resolve();
        });
    });
    return bunBin;
}
async function isBunAvailable() {
    try {
        await verifyBunAvailable();
        return true;
    }
    catch {
        return false;
    }
}
//# sourceMappingURL=runtime.js.map