declare const LOG_LEVEL_ORDER: {
    readonly debug: 10;
    readonly info: 20;
    readonly warn: 30;
    readonly error: 40;
};
type LogLevelKey = keyof typeof LOG_LEVEL_ORDER;
export type LogLevel = LogLevelKey;
export interface Logger {
    info(message: string): void;
    warn(message: string): void;
    error(message: string, error?: unknown): void;
    debug?(message: string): void;
}
export declare function parseLogLevel(value: string | undefined, defaultLevel?: LogLevel): LogLevel;
export declare function resolveLogLevelFromEnv(env?: NodeJS.ProcessEnv, defaultLevel?: LogLevel): LogLevel;
export declare function createPrefixedConsoleLogger(prefix: string, level: LogLevel): Logger;
export {};
//# sourceMappingURL=logging.d.ts.map