import type { ServerToolInfo } from '../../runtime.js';
export interface ToolMetadata {
    tool: ServerToolInfo;
    methodName: string;
    options: GeneratedOption[];
}
export interface GeneratedOption {
    property: string;
    cliName: string;
    description?: string;
    required: boolean;
    type: 'string' | 'number' | 'boolean' | 'array' | 'unknown';
    placeholder: string;
    exampleValue?: string;
    enumValues?: string[];
    defaultValue?: unknown;
    formatHint?: string;
}
export declare function buildToolMetadata(tool: ServerToolInfo): ToolMetadata;
export declare function buildEmbeddedSchemaMap(tools: ToolMetadata[]): Record<string, unknown>;
export declare function extractOptions(tool: ServerToolInfo): GeneratedOption[];
export declare function getEnumValues(descriptor: unknown): string[] | undefined;
export declare function getDescriptorDefault(descriptor: unknown): unknown;
export declare function buildPlaceholder(property: string, type: GeneratedOption['type'], enumValues?: string[], formatSlug?: string): string;
export declare function buildExampleValue(property: string, type: GeneratedOption['type'], enumValues: string[] | undefined, defaultValue: unknown): string | undefined;
export declare function pickExampleLiteral(option: GeneratedOption): string | undefined;
export declare function buildFallbackLiteral(option: GeneratedOption): string;
export declare function inferType(descriptor: unknown): GeneratedOption['type'];
export declare function getDescriptorDescription(descriptor: unknown): string | undefined;
export declare function getDescriptorFormatHint(descriptor: unknown): {
    display: string;
    slug: string;
} | undefined;
export declare function toProxyMethodName(toolName: string): string;
export declare function toCliOption(property: string): string;
export declare const toolsTestHelpers: {
    getEnumValues: typeof getEnumValues;
    getDescriptorDefault: typeof getDescriptorDefault;
    buildPlaceholder: typeof buildPlaceholder;
    buildExampleValue: typeof buildExampleValue;
    pickExampleLiteral: typeof pickExampleLiteral;
    buildFallbackLiteral: typeof buildFallbackLiteral;
};
//# sourceMappingURL=tools.d.ts.map