import type { ConnectionIssue } from '../error-classifier.js';
export interface ConnectionIssueEnvelope {
    server: string;
    tool?: string;
    error: string;
    issue?: SerializedConnectionIssue;
}
export interface SerializedConnectionIssue {
    kind: ConnectionIssue['kind'];
    statusCode?: number;
    stdioExitCode?: number;
    stdioSignal?: string;
    rawMessage?: string;
}
export declare function buildConnectionIssueEnvelope(params: {
    server: string;
    tool?: string;
    error: unknown;
    issue?: ConnectionIssue;
}): ConnectionIssueEnvelope;
export declare function serializeConnectionIssue(issue?: ConnectionIssue): SerializedConnectionIssue | undefined;
export declare function formatErrorMessage(error: unknown): string;
//# sourceMappingURL=json-output.d.ts.map