import os from 'node:os';
import path from 'node:path';

// formatPathForDisplay rewrites absolute paths into user-friendly display strings.
export function formatPathForDisplay(filePath: string): string {
  const cwd = process.cwd();
  const relative = path.relative(cwd, filePath);
  const displayPath =
    relative && !relative.startsWith('..') && !path.isAbsolute(relative)
      ? relative
      : filePath.replace(os.homedir(), '~');
  return displayPath;
}
