import type { Client } from '@modelcontextprotocol/sdk/client/index.js';
import type { Transport } from '@modelcontextprotocol/sdk/shared/transport.js';
import type { Logger } from '../logging.js';
import type { OAuthSession } from '../oauth.js';
export declare const DEFAULT_OAUTH_CODE_TIMEOUT_MS = 60000;
export declare class OAuthTimeoutError extends Error {
    readonly timeoutMs: number;
    readonly serverName: string;
    constructor(serverName: string, timeoutMs: number);
}
export declare function connectWithAuth(client: Client, transport: Transport & {
    close(): Promise<void>;
    finishAuth?: (authorizationCode: string) => Promise<void>;
}, session: OAuthSession | undefined, logger: Logger, options?: {
    serverName?: string;
    maxAttempts?: number;
    oauthTimeoutMs?: number;
}): Promise<void>;
export declare function waitForAuthorizationCodeWithTimeout(session: OAuthSession, logger: Logger, serverName?: string, timeoutMs?: number): Promise<string>;
export declare function parseOAuthTimeout(raw: string | undefined): number;
export declare function resolveOAuthTimeoutFromEnv(): number;
//# sourceMappingURL=oauth.d.ts.map