import type { OAuthClientProvider } from '@modelcontextprotocol/sdk/client/auth.js';
import type { ServerDefinition } from './config.js';
export interface OAuthSession {
    provider: OAuthClientProvider & {
        waitForAuthorizationCode: () => Promise<string>;
    };
    waitForAuthorizationCode: () => Promise<string>;
    close: () => Promise<void>;
}
export declare function createOAuthSession(definition: ServerDefinition, logger: OAuthLogger): Promise<OAuthSession>;
export interface OAuthLogger {
    info(message: string): void;
    warn(message: string): void;
    error(message: string, error?: unknown): void;
}
//# sourceMappingURL=oauth.d.ts.map