import fsSync from 'node:fs';
import type { ServerDefinition } from '../config.js';
import { type Runtime } from '../runtime.js';
import type { DaemonRequest, DaemonResponse } from './protocol.js';
interface DaemonHostOptions {
    readonly socketPath: string;
    readonly metadataPath: string;
    readonly configPath: string;
    readonly rootDir?: string;
    readonly logPath?: string;
    readonly logServers?: Set<string>;
    readonly logAllServers?: boolean;
}
interface ServerActivity {
    connected: boolean;
    lastUsedAt?: number;
}
export declare function runDaemonHost(options: DaemonHostOptions): Promise<void>;
interface LogContext {
    enabled: boolean;
    logAllServers: boolean;
    servers: Set<string>;
    writer?: fsSync.WriteStream;
}
export declare function __testProcessRequest(rawPayload: string, runtime: Runtime, managedServers: Map<string, ServerDefinition>, activity: Map<string, ServerActivity>, metadata: {
    configPath: string;
    socketPath: string;
    startedAt: number;
    logPath: string | null;
}, logContext: LogContext, preParsedRequest?: DaemonRequest): Promise<{
    response: DaemonResponse;
    shouldShutdown: boolean;
}>;
export {};
//# sourceMappingURL=host.d.ts.map