import type { CallToolParams, CloseServerParams, ListResourcesParams, ListToolsParams, StatusResult } from './protocol.js';
export interface DaemonClientOptions {
    readonly configPath: string;
    readonly rootDir?: string;
}
export interface DaemonPaths {
    readonly key: string;
    readonly socketPath: string;
    readonly metadataPath: string;
}
export declare function resolveDaemonPaths(configPath: string): DaemonPaths;
export declare class DaemonClient {
    private readonly options;
    private readonly socketPath;
    private readonly metadataPath;
    private startingPromise;
    constructor(options: DaemonClientOptions);
    callTool(params: CallToolParams): Promise<unknown>;
    listTools(params: ListToolsParams): Promise<unknown>;
    listResources(params: ListResourcesParams): Promise<unknown>;
    closeServer(params: CloseServerParams): Promise<void>;
    status(): Promise<StatusResult | null>;
    stop(): Promise<void>;
    private invoke;
    private ensureDaemon;
    private restartDaemon;
    private startDaemon;
    private waitForReady;
    private isResponsive;
    private sendRequest;
}
//# sourceMappingURL=client.d.ts.map