import { type LoadConfigOptions, type RawConfig, type ServerDefinition } from './config-schema.js';
export { toFileUrl } from './config-imports.js';
export { __configInternals } from './config-normalize.js';
export type { CommandSpec, HttpCommand, LoadConfigOptions, RawConfig, RawEntry, ServerDefinition, ServerLifecycle, ServerLoggingOptions, ServerSource, StdioCommand, } from './config-schema.js';
export declare function loadServerDefinitions(options?: LoadConfigOptions): Promise<ServerDefinition[]>;
export declare function loadRawConfig(options?: LoadConfigOptions): Promise<{
    config: RawConfig;
    path: string;
    explicit: boolean;
}>;
export declare function writeRawConfig(targetPath: string, config: RawConfig): Promise<void>;
export declare function resolveConfigPath(configPath: string | undefined, rootDir: string): {
    path: string;
    explicit: boolean;
};
//# sourceMappingURL=config.d.ts.map