import { z } from 'zod';
export declare const ImportKindSchema: z.ZodEnum<["cursor", "claude-code", "claude-desktop", "codex", "windsurf", "opencode", "vscode"]>;
export type ImportKind = z.infer<typeof ImportKindSchema>;
export declare const DEFAULT_IMPORTS: ImportKind[];
declare const RawLifecycleSchema: z.ZodUnion<[z.ZodLiteral<"keep-alive">, z.ZodLiteral<"ephemeral">, z.ZodObject<{
    mode: z.ZodUnion<[z.ZodLiteral<"keep-alive">, z.ZodLiteral<"ephemeral">]>;
    idleTimeoutMs: z.ZodOptional<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    mode: "keep-alive" | "ephemeral";
    idleTimeoutMs?: number | undefined;
}, {
    mode: "keep-alive" | "ephemeral";
    idleTimeoutMs?: number | undefined;
}>]>;
export type RawLifecycle = z.infer<typeof RawLifecycleSchema>;
export declare const RawEntrySchema: z.ZodObject<{
    description: z.ZodOptional<z.ZodString>;
    baseUrl: z.ZodOptional<z.ZodString>;
    base_url: z.ZodOptional<z.ZodString>;
    url: z.ZodOptional<z.ZodString>;
    serverUrl: z.ZodOptional<z.ZodString>;
    server_url: z.ZodOptional<z.ZodString>;
    command: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
    executable: z.ZodOptional<z.ZodString>;
    args: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    headers: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    auth: z.ZodOptional<z.ZodString>;
    tokenCacheDir: z.ZodOptional<z.ZodString>;
    token_cache_dir: z.ZodOptional<z.ZodString>;
    clientName: z.ZodOptional<z.ZodString>;
    client_name: z.ZodOptional<z.ZodString>;
    oauthRedirectUrl: z.ZodOptional<z.ZodString>;
    oauth_redirect_url: z.ZodOptional<z.ZodString>;
    bearerToken: z.ZodOptional<z.ZodString>;
    bearer_token: z.ZodOptional<z.ZodString>;
    bearerTokenEnv: z.ZodOptional<z.ZodString>;
    bearer_token_env: z.ZodOptional<z.ZodString>;
    lifecycle: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"keep-alive">, z.ZodLiteral<"ephemeral">, z.ZodObject<{
        mode: z.ZodUnion<[z.ZodLiteral<"keep-alive">, z.ZodLiteral<"ephemeral">]>;
        idleTimeoutMs: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        mode: "keep-alive" | "ephemeral";
        idleTimeoutMs?: number | undefined;
    }, {
        mode: "keep-alive" | "ephemeral";
        idleTimeoutMs?: number | undefined;
    }>]>>;
    logging: z.ZodOptional<z.ZodObject<{
        daemon: z.ZodOptional<z.ZodObject<{
            enabled: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            enabled?: boolean | undefined;
        }, {
            enabled?: boolean | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        daemon?: {
            enabled?: boolean | undefined;
        } | undefined;
    }, {
        daemon?: {
            enabled?: boolean | undefined;
        } | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    description?: string | undefined;
    baseUrl?: string | undefined;
    base_url?: string | undefined;
    url?: string | undefined;
    serverUrl?: string | undefined;
    server_url?: string | undefined;
    command?: string | string[] | undefined;
    executable?: string | undefined;
    args?: string[] | undefined;
    headers?: Record<string, string> | undefined;
    env?: Record<string, string> | undefined;
    auth?: string | undefined;
    tokenCacheDir?: string | undefined;
    token_cache_dir?: string | undefined;
    clientName?: string | undefined;
    client_name?: string | undefined;
    oauthRedirectUrl?: string | undefined;
    oauth_redirect_url?: string | undefined;
    bearerToken?: string | undefined;
    bearer_token?: string | undefined;
    bearerTokenEnv?: string | undefined;
    bearer_token_env?: string | undefined;
    lifecycle?: "keep-alive" | "ephemeral" | {
        mode: "keep-alive" | "ephemeral";
        idleTimeoutMs?: number | undefined;
    } | undefined;
    logging?: {
        daemon?: {
            enabled?: boolean | undefined;
        } | undefined;
    } | undefined;
}, {
    description?: string | undefined;
    baseUrl?: string | undefined;
    base_url?: string | undefined;
    url?: string | undefined;
    serverUrl?: string | undefined;
    server_url?: string | undefined;
    command?: string | string[] | undefined;
    executable?: string | undefined;
    args?: string[] | undefined;
    headers?: Record<string, string> | undefined;
    env?: Record<string, string> | undefined;
    auth?: string | undefined;
    tokenCacheDir?: string | undefined;
    token_cache_dir?: string | undefined;
    clientName?: string | undefined;
    client_name?: string | undefined;
    oauthRedirectUrl?: string | undefined;
    oauth_redirect_url?: string | undefined;
    bearerToken?: string | undefined;
    bearer_token?: string | undefined;
    bearerTokenEnv?: string | undefined;
    bearer_token_env?: string | undefined;
    lifecycle?: "keep-alive" | "ephemeral" | {
        mode: "keep-alive" | "ephemeral";
        idleTimeoutMs?: number | undefined;
    } | undefined;
    logging?: {
        daemon?: {
            enabled?: boolean | undefined;
        } | undefined;
    } | undefined;
}>;
export declare const RawConfigSchema: z.ZodObject<{
    mcpServers: z.ZodRecord<z.ZodString, z.ZodObject<{
        description: z.ZodOptional<z.ZodString>;
        baseUrl: z.ZodOptional<z.ZodString>;
        base_url: z.ZodOptional<z.ZodString>;
        url: z.ZodOptional<z.ZodString>;
        serverUrl: z.ZodOptional<z.ZodString>;
        server_url: z.ZodOptional<z.ZodString>;
        command: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
        executable: z.ZodOptional<z.ZodString>;
        args: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        headers: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        auth: z.ZodOptional<z.ZodString>;
        tokenCacheDir: z.ZodOptional<z.ZodString>;
        token_cache_dir: z.ZodOptional<z.ZodString>;
        clientName: z.ZodOptional<z.ZodString>;
        client_name: z.ZodOptional<z.ZodString>;
        oauthRedirectUrl: z.ZodOptional<z.ZodString>;
        oauth_redirect_url: z.ZodOptional<z.ZodString>;
        bearerToken: z.ZodOptional<z.ZodString>;
        bearer_token: z.ZodOptional<z.ZodString>;
        bearerTokenEnv: z.ZodOptional<z.ZodString>;
        bearer_token_env: z.ZodOptional<z.ZodString>;
        lifecycle: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"keep-alive">, z.ZodLiteral<"ephemeral">, z.ZodObject<{
            mode: z.ZodUnion<[z.ZodLiteral<"keep-alive">, z.ZodLiteral<"ephemeral">]>;
            idleTimeoutMs: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            mode: "keep-alive" | "ephemeral";
            idleTimeoutMs?: number | undefined;
        }, {
            mode: "keep-alive" | "ephemeral";
            idleTimeoutMs?: number | undefined;
        }>]>>;
        logging: z.ZodOptional<z.ZodObject<{
            daemon: z.ZodOptional<z.ZodObject<{
                enabled: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                enabled?: boolean | undefined;
            }, {
                enabled?: boolean | undefined;
            }>>;
        }, "strip", z.ZodTypeAny, {
            daemon?: {
                enabled?: boolean | undefined;
            } | undefined;
        }, {
            daemon?: {
                enabled?: boolean | undefined;
            } | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        description?: string | undefined;
        baseUrl?: string | undefined;
        base_url?: string | undefined;
        url?: string | undefined;
        serverUrl?: string | undefined;
        server_url?: string | undefined;
        command?: string | string[] | undefined;
        executable?: string | undefined;
        args?: string[] | undefined;
        headers?: Record<string, string> | undefined;
        env?: Record<string, string> | undefined;
        auth?: string | undefined;
        tokenCacheDir?: string | undefined;
        token_cache_dir?: string | undefined;
        clientName?: string | undefined;
        client_name?: string | undefined;
        oauthRedirectUrl?: string | undefined;
        oauth_redirect_url?: string | undefined;
        bearerToken?: string | undefined;
        bearer_token?: string | undefined;
        bearerTokenEnv?: string | undefined;
        bearer_token_env?: string | undefined;
        lifecycle?: "keep-alive" | "ephemeral" | {
            mode: "keep-alive" | "ephemeral";
            idleTimeoutMs?: number | undefined;
        } | undefined;
        logging?: {
            daemon?: {
                enabled?: boolean | undefined;
            } | undefined;
        } | undefined;
    }, {
        description?: string | undefined;
        baseUrl?: string | undefined;
        base_url?: string | undefined;
        url?: string | undefined;
        serverUrl?: string | undefined;
        server_url?: string | undefined;
        command?: string | string[] | undefined;
        executable?: string | undefined;
        args?: string[] | undefined;
        headers?: Record<string, string> | undefined;
        env?: Record<string, string> | undefined;
        auth?: string | undefined;
        tokenCacheDir?: string | undefined;
        token_cache_dir?: string | undefined;
        clientName?: string | undefined;
        client_name?: string | undefined;
        oauthRedirectUrl?: string | undefined;
        oauth_redirect_url?: string | undefined;
        bearerToken?: string | undefined;
        bearer_token?: string | undefined;
        bearerTokenEnv?: string | undefined;
        bearer_token_env?: string | undefined;
        lifecycle?: "keep-alive" | "ephemeral" | {
            mode: "keep-alive" | "ephemeral";
            idleTimeoutMs?: number | undefined;
        } | undefined;
        logging?: {
            daemon?: {
                enabled?: boolean | undefined;
            } | undefined;
        } | undefined;
    }>>;
    imports: z.ZodOptional<z.ZodArray<z.ZodEnum<["cursor", "claude-code", "claude-desktop", "codex", "windsurf", "opencode", "vscode"]>, "many">>;
}, "strip", z.ZodTypeAny, {
    mcpServers: Record<string, {
        description?: string | undefined;
        baseUrl?: string | undefined;
        base_url?: string | undefined;
        url?: string | undefined;
        serverUrl?: string | undefined;
        server_url?: string | undefined;
        command?: string | string[] | undefined;
        executable?: string | undefined;
        args?: string[] | undefined;
        headers?: Record<string, string> | undefined;
        env?: Record<string, string> | undefined;
        auth?: string | undefined;
        tokenCacheDir?: string | undefined;
        token_cache_dir?: string | undefined;
        clientName?: string | undefined;
        client_name?: string | undefined;
        oauthRedirectUrl?: string | undefined;
        oauth_redirect_url?: string | undefined;
        bearerToken?: string | undefined;
        bearer_token?: string | undefined;
        bearerTokenEnv?: string | undefined;
        bearer_token_env?: string | undefined;
        lifecycle?: "keep-alive" | "ephemeral" | {
            mode: "keep-alive" | "ephemeral";
            idleTimeoutMs?: number | undefined;
        } | undefined;
        logging?: {
            daemon?: {
                enabled?: boolean | undefined;
            } | undefined;
        } | undefined;
    }>;
    imports?: ("cursor" | "claude-code" | "claude-desktop" | "codex" | "windsurf" | "opencode" | "vscode")[] | undefined;
}, {
    mcpServers: Record<string, {
        description?: string | undefined;
        baseUrl?: string | undefined;
        base_url?: string | undefined;
        url?: string | undefined;
        serverUrl?: string | undefined;
        server_url?: string | undefined;
        command?: string | string[] | undefined;
        executable?: string | undefined;
        args?: string[] | undefined;
        headers?: Record<string, string> | undefined;
        env?: Record<string, string> | undefined;
        auth?: string | undefined;
        tokenCacheDir?: string | undefined;
        token_cache_dir?: string | undefined;
        clientName?: string | undefined;
        client_name?: string | undefined;
        oauthRedirectUrl?: string | undefined;
        oauth_redirect_url?: string | undefined;
        bearerToken?: string | undefined;
        bearer_token?: string | undefined;
        bearerTokenEnv?: string | undefined;
        bearer_token_env?: string | undefined;
        lifecycle?: "keep-alive" | "ephemeral" | {
            mode: "keep-alive" | "ephemeral";
            idleTimeoutMs?: number | undefined;
        } | undefined;
        logging?: {
            daemon?: {
                enabled?: boolean | undefined;
            } | undefined;
        } | undefined;
    }>;
    imports?: ("cursor" | "claude-code" | "claude-desktop" | "codex" | "windsurf" | "opencode" | "vscode")[] | undefined;
}>;
export type RawEntry = z.infer<typeof RawEntrySchema>;
export type RawConfig = z.infer<typeof RawConfigSchema>;
export interface HttpCommand {
    readonly kind: 'http';
    readonly url: URL;
    readonly headers?: Record<string, string>;
}
export interface StdioCommand {
    readonly kind: 'stdio';
    readonly command: string;
    readonly args: string[];
    readonly cwd: string;
}
export type CommandSpec = HttpCommand | StdioCommand;
export interface ServerSource {
    readonly kind: 'local' | 'import';
    readonly path: string;
    readonly importKind?: ImportKind;
}
export type ServerLifecycle = {
    mode: 'keep-alive';
    idleTimeoutMs?: number;
} | {
    mode: 'ephemeral';
};
export interface ServerLoggingOptions {
    readonly daemon?: {
        readonly enabled?: boolean;
    };
}
export interface ServerDefinition {
    readonly name: string;
    readonly description?: string;
    readonly command: CommandSpec;
    readonly env?: Record<string, string>;
    readonly auth?: string;
    readonly tokenCacheDir?: string;
    readonly clientName?: string;
    readonly oauthRedirectUrl?: string;
    readonly source?: ServerSource;
    readonly sources?: readonly ServerSource[];
    readonly lifecycle?: ServerLifecycle;
    readonly logging?: ServerLoggingOptions;
}
export interface LoadConfigOptions {
    readonly configPath?: string;
    readonly rootDir?: string;
}
export {};
//# sourceMappingURL=config-schema.d.ts.map