import type { ServerDefinition, ServerSource } from '../config.js';
import type { ConnectionIssue } from '../error-classifier.js';
import type { ServerToolInfo } from '../runtime.js';
export type StatusCategory = 'ok' | 'auth' | 'offline' | 'http' | 'error';
export type ListSummaryResult = {
    status: 'ok';
    server: ServerDefinition;
    tools: ServerToolInfo[];
    durationMs: number;
} | {
    status: 'error';
    server: ServerDefinition;
    error: unknown;
    durationMs: number;
};
export declare function renderServerListRow(result: ListSummaryResult, timeoutMs: number, options?: {
    verbose?: boolean;
}): {
    line: string;
    summary: string;
    category: StatusCategory;
    authCommand?: string;
    issue?: ConnectionIssue;
};
export declare function truncateForSpinner(text: string, maxLength?: number): string;
export declare function formatSourceSuffix(sourceOrSources: ServerSource | readonly ServerSource[] | undefined, inline?: boolean, options?: {
    verbose?: boolean;
}): string;
export declare function classifyListError(error: unknown, serverName: string, _timeoutSeconds: number, options?: {
    authCommand?: string;
}): {
    colored: string;
    summary: string;
    category: StatusCategory;
    authCommand?: string;
    issue: ConnectionIssue;
};
//# sourceMappingURL=list-format.d.ts.map