export function extractGeneratorFlags(args, options = {}) {
    const result = {};
    let index = 0;
    while (index < args.length) {
        const token = args[index];
        if (!token) {
            index += 1;
            continue;
        }
        if (token === '--runtime') {
            const value = args[index + 1];
            if (value !== 'node' && value !== 'bun') {
                throw new Error("--runtime must be 'node' or 'bun'.");
            }
            result.runtime = value;
            args.splice(index, 2);
            continue;
        }
        if (token === '--timeout') {
            const raw = args[index + 1];
            if (!raw) {
                throw new Error("Flag '--timeout' requires a value.");
            }
            const parsed = Number.parseInt(raw, 10);
            if (!Number.isFinite(parsed) || parsed <= 0) {
                throw new Error('--timeout must be a positive integer.');
            }
            result.timeout = parsed;
            args.splice(index, 2);
            continue;
        }
        if (options.allowIncludeOptional && (token === '--include-optional' || token === '--all-parameters')) {
            result.includeOptional = true;
            args.splice(index, 1);
            continue;
        }
        index += 1;
    }
    return result;
}
//# sourceMappingURL=flag-parser.js.map