import type { Runtime } from '../runtime.js';
import { type ToolDocEntry } from './emit-ts-templates.js';
import type { ToolMetadata } from './generate/tools.js';
interface EmitTsFlags {
    server?: string;
    outPath?: string;
    mode: 'types' | 'client';
    includeOptional: boolean;
    typesOutPath?: string;
    format: 'text' | 'json';
}
interface ParsedEmitTsOptions extends Required<Omit<EmitTsFlags, 'server' | 'outPath' | 'typesOutPath'>> {
    server: string;
    outPath: string;
    typesOutPath?: string;
}
export declare function handleEmitTs(runtime: Runtime, args: string[]): Promise<void>;
declare function parseEmitTsArgs(args: string[]): ParsedEmitTsOptions;
declare function buildDocEntries(serverName: string, metadataEntries: ToolMetadata[], includeOptional: boolean): ToolDocEntry[];
declare function buildInterfaceName(serverName: string): string;
declare function deriveTypesOutPath(tsPath: string): string;
declare function computeImportPath(fromPath: string, typesPath: string): string;
export declare const __test: {
    parseEmitTsArgs: typeof parseEmitTsArgs;
    buildInterfaceName: typeof buildInterfaceName;
    deriveTypesOutPath: typeof deriveTypesOutPath;
    computeImportPath: typeof computeImportPath;
    buildDocEntries: typeof buildDocEntries;
};
export {};
//# sourceMappingURL=emit-ts-command.d.ts.map