export type ConfigSubcommand = 'list' | 'get' | 'add' | 'remove' | 'import' | 'login' | 'logout' | 'doctor';
export type ConfigHelpEntry = {
    readonly name: string;
    readonly summary: string;
    readonly usage: string;
    readonly description: string;
    readonly flags?: Array<{
        flag: string;
        description: string;
    }>;
    readonly examples?: string[];
};
export declare const CONFIG_HELP_ENTRIES: Record<ConfigSubcommand, ConfigHelpEntry>;
export declare const CONFIG_HELP_ORDER: ConfigSubcommand[];
export declare function isHelpToken(token: string): boolean;
export declare function consumeInlineHelpTokens(args: string[]): boolean;
export declare function printConfigHelp(subcommand?: string): void;
//# sourceMappingURL=help.d.ts.map