import { resolveEnvPlaceholders } from './env.js';
// materializeHeaders resolves environment placeholders in server header definitions.
export function materializeHeaders(headers, serverName) {
    if (!headers) {
        return undefined;
    }
    const resolved = {};
    for (const [key, value] of Object.entries(headers)) {
        try {
            resolved[key] = resolveEnvPlaceholders(value);
        }
        catch (error) {
            const message = error instanceof Error ? error.message : String(error);
            throw new Error(`Failed to resolve header '${key}' for server '${serverName}': ${message}`);
        }
    }
    return resolved;
}
//# sourceMappingURL=runtime-header-utils.js.map