import { type ConnectionIssue } from './error-classifier.js';
export interface CallResult<T = unknown> {
    raw: T;
    text(joiner?: string): string | null;
    markdown(joiner?: string): string | null;
    json<J = unknown>(): J | null;
    content(): unknown[] | null;
    structuredContent(): unknown;
}
export declare function createCallResult<T = unknown>(raw: T): CallResult<T>;
export type { ConnectionIssue } from './error-classifier.js';
export declare function describeConnectionIssue(error: unknown): ConnectionIssue;
export declare function wrapCallResult<T = unknown>(raw: T): {
    raw: T;
    callResult: CallResult<T>;
};
//# sourceMappingURL=result-utils.d.ts.map