import { createPrefixedConsoleLogger, resolveLogLevelFromEnv } from '../logging.js';
let activeLogLevel = resolveLogLevelFromEnv();
let activeLogger = createPrefixedConsoleLogger('mcporter', activeLogLevel);
export function getActiveLogLevel() {
    return activeLogLevel;
}
export function getActiveLogger() {
    return activeLogger;
}
export function setLogLevel(level) {
    activeLogLevel = level;
    activeLogger = createPrefixedConsoleLogger('mcporter', activeLogLevel);
}
export function setLogger(logger, level) {
    activeLogger = logger;
    if (level) {
        activeLogLevel = level;
    }
}
export function logInfo(message) {
    activeLogger.info(message);
}
export function logWarn(message) {
    activeLogger.warn(message);
}
export function logError(message, error) {
    activeLogger.error(message, error);
}
//# sourceMappingURL=logger-context.js.map