import type { GeneratedOption } from './generate/tools.js';
export interface SignatureFormatOptions {
    colorize?: boolean;
    defaultReturnType?: string;
}
export interface FlagUsageExtra {
    text: string;
    required?: boolean;
}
export declare function formatFunctionSignature(name: string, options: GeneratedOption[], outputSchema: unknown, formatOptions?: SignatureFormatOptions): string;
export declare function formatOptionalSummary(hiddenOptions: GeneratedOption[], options?: {
    colorize?: boolean;
}): string;
export declare function formatFlagUsage(options: GeneratedOption[], extras?: FlagUsageExtra[], opts?: {
    colorize?: boolean;
}): string;
export declare function formatFlagLabel(option: GeneratedOption): string;
export declare function formatCallExpressionExample(serverName: string, toolName: string, options: GeneratedOption[], extra?: {
    callSelector?: string;
    wrapExpression?: boolean;
}): string | undefined;
export declare function formatExampleBlock(examples: string[], options?: {
    maxExamples?: number;
    maxLength?: number;
}): string[];
//# sourceMappingURL=list-signature.d.ts.map