import type { ServerDefinition } from '../config.js';
import type { ToolMetadata } from './generate/tools.js';
import type { SerializedConnectionIssue } from './json-output.js';
import type { ListSummaryResult, StatusCategory } from './list-format.js';
export interface ToolDetailResult {
    examples: string[];
    optionalOmitted: boolean;
}
export interface ListJsonServerEntry {
    name: string;
    status: StatusCategory;
    durationMs: number;
    description?: string;
    transport?: string;
    source?: ServerDefinition['source'];
    sources?: ServerDefinition['sources'];
    tools?: Array<{
        name: string;
        description?: string;
        inputSchema?: unknown;
        outputSchema?: unknown;
    }>;
    issue?: SerializedConnectionIssue;
    authCommand?: string;
    error?: string;
}
export declare function printSingleServerHeader(definition: ReturnType<Awaited<ReturnType<typeof import('../runtime.js')['createRuntime']>>['getDefinition']>, toolCount: number | undefined, durationMs: number | undefined, transportSummary: string, sourcePath: string | undefined, options?: {
    printSummaryNow?: boolean;
}): string;
export declare function printToolDetail(definition: ReturnType<Awaited<ReturnType<typeof import('../runtime.js')['createRuntime']>>['getDefinition']>, metadata: ToolMetadata, includeSchema: boolean, requiredOnly: boolean): ToolDetailResult;
export declare function createEmptyStatusCounts(): Record<StatusCategory, number>;
export declare function summarizeStatusCounts(entries: ListJsonServerEntry[]): Record<StatusCategory, number>;
export declare function buildJsonListEntry(result: ListSummaryResult, timeoutSeconds: number, options: {
    includeSchemas: boolean;
    includeSources?: boolean;
}): ListJsonServerEntry;
export declare function createUnknownResult(server: ServerDefinition): ListSummaryResult;
export declare function buildAuthCommandHint(definition: ReturnType<Awaited<ReturnType<typeof import('../runtime.js')['createRuntime']>>['getDefinition']>): string;
//# sourceMappingURL=list-output.d.ts.map