import type { CliArtifactMetadata } from '../../cli-metadata.js';
import type { ServerDefinition } from '../../config.js';
import { buildToolDoc } from '../list-detail-helpers.js';
import type { ToolMetadata } from './tools.js';
export interface TemplateInput {
    outputPath?: string;
    runtimeKind: 'node' | 'bun';
    timeoutMs: number;
    definition: ServerDefinition;
    serverName: string;
    tools: ToolMetadata[];
    generator: {
        name: string;
        version: string;
    };
    metadata: CliArtifactMetadata;
}
export declare function writeTemplate(input: TemplateInput): Promise<string>;
export declare function readPackageMetadata(): Promise<{
    name: string;
    version: string;
}>;
export declare function renderTemplate({ runtimeKind, timeoutMs, definition, serverName, tools, generator, metadata, }: TemplateInput): string;
export declare function renderToolCommand(tool: ToolMetadata, defaultTimeout: number, serverName: string, existingDoc?: ReturnType<typeof buildToolDoc>): {
    block: string;
    commandName: string;
    signature: string;
    tsSignature: string;
};
//# sourceMappingURL=template.d.ts.map