import type { ServerDefinition } from '../../config-schema.js';
export type SerializedServerDefinition = {
    name: string;
    description?: string;
    source: NonNullable<ServerDefinition['source']> | {
        kind: 'local';
        path: string;
    };
    auth?: ServerDefinition['auth'];
    tokenCacheDir?: string;
    clientName?: string;
    oauthRedirectUrl?: string;
    env?: Record<string, string>;
    transport: 'http' | 'stdio';
    baseUrl?: string;
    headers?: Record<string, string>;
    command?: string;
    args?: string[];
    cwd?: string;
};
export declare function serializeDefinition(definition: ServerDefinition): SerializedServerDefinition;
export declare function printServerSummary(definition: ServerDefinition): void;
export declare function printImportSummary(importServers: ServerDefinition[]): void;
export declare function printConfigUsageExamples(): string[];
//# sourceMappingURL=render.d.ts.map