import type { LoadConfigOptions } from '../../config.js';
import type { ConfigCliOptions } from './types.js';
export type AddFlags = {
    transport?: 'http' | 'sse' | 'stdio';
    url?: string;
    command?: string;
    stdio?: string;
    args: string[];
    description?: string;
    env: Record<string, string>;
    headers: Record<string, string>;
    tokenCacheDir?: string;
    clientName?: string;
    oauthRedirectUrl?: string;
    auth?: string;
    copyFrom?: string;
    persistPath?: string;
    scope?: 'home' | 'project';
    dryRun?: boolean;
};
export declare function handleAddCommand(options: ConfigCliOptions, args: string[]): Promise<void>;
export declare function resolveWriteTarget(flags: AddFlags, loadOptions: LoadConfigOptions, rootDir: string): string;
//# sourceMappingURL=add.d.ts.map