import { spawn } from 'node:child_process';
import path from 'node:path';
export function launchDaemonDetached(options) {
    const cliEntry = resolveCliEntry();
    const args = [
        ...process.execArgv,
        cliEntry,
        '--config',
        options.configPath,
        ...(options.rootDir ? ['--root', options.rootDir] : []),
        'daemon',
        'start',
        '--foreground',
        ...(options.extraArgs ?? []),
    ];
    const child = spawn(process.execPath, args, {
        detached: true,
        stdio: 'ignore',
        env: {
            ...process.env,
            MCPORTER_DAEMON_CHILD: '1',
            MCPORTER_DAEMON_SOCKET: options.socketPath,
            MCPORTER_DAEMON_METADATA: options.metadataPath,
        },
    });
    child.unref();
}
function resolveCliEntry() {
    const entry = process.argv[1];
    if (!entry) {
        throw new Error('Unable to resolve mcporter entry script.');
    }
    return path.resolve(entry);
}
//# sourceMappingURL=launch.js.map