import type { LoadConfigOptions, RawConfig } from '../../config.js';
import type { ServerDefinition } from '../../config-schema.js';
export declare const COLOR_ENABLED: () => boolean;
export type ConfigLocationSummary = {
    projectPath: string;
    projectExists: boolean;
    systemPath: string;
    systemExists: boolean;
};
export declare function cloneConfig(config: RawConfig): RawConfig;
export declare function loadOrCreateConfig(loadOptions: LoadConfigOptions): Promise<{
    config: RawConfig;
    path: string;
}>;
export declare function resolveConfigLocations(loadOptions: LoadConfigOptions): Promise<ConfigLocationSummary>;
export declare function logConfigLocations(summary: ConfigLocationSummary, options?: {
    leadingNewline?: boolean;
}): void;
export declare function findServerNameWithFuzzyMatch(name: string, candidates: string[], logger?: ((message: string) => void) | null): string | null;
export declare function resolveServerDefinition(name: string, servers: ServerDefinition[], logger?: ((message: string) => void) | null): ServerDefinition;
//# sourceMappingURL=shared.d.ts.map